
#include "CWykres3D.h"
#include "colormaps.cpp"
#include "Varia.h"

#include <gl\glu.h>

CWykres3D::CWykres3D()
	:COknoGL()
{
	error = 1;

	if(__argc<3) {
		MessageBox(NULL,"Brak nazwy pliku w parametrze linii komend","Wykres 3D",MB_OK | MB_ICONWARNING);
		PostQuitMessage(0);
		return;
	}

	psi = NULL;
	gp  = NULL;
	list_id=0;

	lposX=-10.0; 
	lposY=0.0;
	lposZ=10.0;

	ileTrafien=NRWybranegoObiektu=0;

	if (!CzytajParametryProgramu("konfiguracja.par ")) {PostQuitMessage(WM_QUIT); return;}
	if (!CzytajParametrySieci(__argv[2])) {PostQuitMessage(WM_QUIT); return;}
	if (!CzytajDane(__argv[1])) {PostQuitMessage(WM_QUIT); return;}
	UstawIJZakres();
	MinMax2D();
	UstawSkale();
	UstawKolor();	

	error=0;
}

CWykres3D::~CWykres3D()
{
	if (gp==NULL) return;
	
	if (psi!=NULL) {
		for(int i=0; i<gp->GetNx(); i++) { //zwolnij pami zajmowana przez dane
			delete[] psi[i];               
			psi[i]=0;
		}
		delete[] psi;
	}

	delete gp;

	glDeleteLists(list_id, 1);
	KillFont(czcionka, 256);
}


int CWykres3D::Parametr(char *parametr)
{
	if (!strcmp(parametr,"end")) return PARAM_END;
	if (!strcmp(parametr,"xrange")) return PARAM_XRANGE;
	if (!strcmp(parametr,"yrange")) return PARAM_YRANGE;
	if (!strcmp(parametr,"scale"))  return PARAM_SCALE;
	if (!strcmp(parametr,"every"))  return PARAM_EVERY;
	if (!strcmp(parametr,"palette")) return PARAM_PALETTE;
	if (!strcmp(parametr,"type"))    return PARAM_TYPE;
	if (!strcmp(parametr,"mod_psi")) return PARAM_MOD_PSI;
	if (!strcmp(parametr,"color")) return PARAM_COLOR;
	return PARAM_ERROR;
}

int CWykres3D::CzytajParametryProgramu(char *plikKonfiguracyjny)
{
	ifstream input(plikKonfiguracyjny);
	if (!input.is_open()) return 0;
 
	char opcja[50];
	while (!input.eof()) {
		input>>opcja;
		switch (Parametr(opcja)) {
			case PARAM_END : 
					 return 1;
			case PARAM_XRANGE : 
					 input>>Xmin;
					 input>>Xmax;
					 break;
			case PARAM_YRANGE : 
					 input>>Ymin;
					 input>>Ymax;
					 break;
			case PARAM_SCALE : 
					 input>>skala;
					 break;
			case PARAM_EVERY : 
					 input>>every;
					 break;
			case PARAM_PALETTE : 
					 input>>paleta;
					 break;
			case PARAM_TYPE : 
					 input>>typ;
					 break;
			case PARAM_MOD_PSI : 
					 input>>mod_psi;
					 break;
			case PARAM_COLOR : 
					 input>>kolor.r;
					 input>>kolor.g;
					 input>>kolor.b;
					 break;
			default : return 0;
		}
	}

	return 1;
}

int CWykres3D::CzytajParametrySieci(char *nazwaPliku)
{
	ifstream input(nazwaPliku);
	if (!input.is_open()) return 0;


    gp = new GridParam();
	gp->FromFile(input);

	return 1;
} 

int CWykres3D::CzytajDane(const char *nazwaPliku)
{
    //przygotowujemy pami dla tablicy 2D
    psi = new pfpsi[gp->GetNx()];
    for(int i=0; i<gp->GetNx(); i++) 
		psi[i]=new fpsi[gp->GetNy()];

    //otwieramy plik o nazwie wskazanej przez OpenDialog->FileName
    ifstream input(nazwaPliku);
	if (!input.is_open()) return 0;

    char line[255];

    //pobieramy pierwsze linie w pliku, ktre zawieraja #
	while(input.peek()=='#') 
        input.getline(line,255);
	
    //wczytujemy dane do tablicy
    for (int j=0; j<gp->GetNy(); j++)
		for (int i=0; i<gp->GetNx(); i++)
            input>>(psi[i][j].psi_value);
        
    input.close();  //zamykamy plik
	return 1;
}  

void CWykres3D::UstawIJZakres()
{
    //jeli Xmin jest mniejsze od minimalnej wartoci
    //sieci przestrzennej na osi OX przypisz Xmin  najmniejsza moliwa warto
    if (Xmin<gp->GetXmin()) Xmin=gp->GetXmin();
    imin = gp->GetIndexX(Xmin); //wyznaczamy indeks odpowiadajcy wartoci Xmin

    //jeli Xmax jest wiksze od najwikszej wartoci
    //sieci przestrzennej na osi OX przypisz Xmax  najwiksza moliwa warto
    if (Xmax>gp->GetXmax()) Xmax=gp->GetXmax();
    imax = gp->GetIndexX(Xmax); //wyznaczamy indeks odpowiadajcy wartoci Xmax

    //jeli Ymin jest mniejsze od minimalnej wartoci
    //sieci przestrzennej na osi OY przypisz Ymin  najmniejsza moliwa warto
    if (Ymin<gp->GetYmin()) Ymin=gp->GetYmin();
    jmin = gp->GetIndexY(Ymin); //wyznaczamy indeks odpowiadajcy wartoci Ymin

    //jeli Ymax jest wiksze od najwikszej wartoci
    //sieci przestrzennej na osi OY przypisz Ymax  najwiksza moliwa warto
    if (Ymax>gp->GetYmax()) Ymax=gp->GetYmax();
    jmax = gp->GetIndexY(Ymax); //wyznaczamy indeks odpowiadajcy wartoci Ymax

    //wyznaczamy rodek przedziau na osi OX
    x_sr = (Xmax+Xmin)/2.0;
    //wyznaczamy rodek przedziau na osi OY
    y_sr = (Ymax+Ymin)/2.0;
}

void CWykres3D::MinMax2D()
{
    minpsi=maxpsi=psi[imin][jmin].psi_value;
    _min=_max=minpsi*minpsi;
    //szukamy w wierszach tablicy psi poczawszy od imin a do imax
    for (int i=imin; i<=imax; i++)
        //szukamy w kolumnach tablicy psi poczawszy od jmin a do jmax
        for (int j=jmin; j<=jmax; j++){
        	if (psi[i][j].psi_value<minpsi) minpsi=psi[i][j].psi_value;
        	else if (psi[i][j].psi_value>maxpsi) maxpsi=psi[i][j].psi_value;

            if (psi[i][j].psi_value*psi[i][j].psi_value<_min) _min=psi[i][j].psi_value*psi[i][j].psi_value;
            else if (psi[i][j].psi_value*psi[i][j].psi_value>_max)_max=psi[i][j].psi_value*psi[i][j].psi_value;
    }
}

void CWykres3D::UstawSkale()
{
    //jeeli mod_psi = false
    if (!mod_psi) {
        //jeeli minpsi!=0 i |minpis| jest wiksza od |maxpsi|
        if (minpsi && (fabs(minpsi)>fabs(maxpsi))) wsp=skala/fabs(minpsi);
        //jeeli maxpsi!=0 i |maxpis| jest wiksza bad rwna |minpsi|
        else if (maxpsi && (fabs(minpsi)<=fabs(maxpsi))) wsp=skala/fabs(maxpsi);
        //jeeli minpsi i maxpsi sa rwne 0
        else wsp=0.0;
    } else { //jeeli mod_psi  = true
        //jeeli _max jest rne od zera
        if (_max)
            wsp=skala/_max;
        //w przeciwnym razie
        else wsp=0.0;
    }
    //wyznaczamy wartoci minimalna oraz maksymalna uwzgldniajac
    //zmienne mod_psi oraz wsp (skala)
    min_value=(mod_psi?_min:minpsi)*wsp;
    max_value=(mod_psi?_max:maxpsi)*wsp;
}

rgb_triplet CWykres3D::Kolor(double minpsi, double maxpsi, double psi)
{
    switch (paleta) {
        case 0 : return SetColorSzary(minpsi, maxpsi, psi);
        case 1 : return SetColorN5(minpsi, maxpsi, psi);  //wybrano palet N5
        case 2 : return SetColorN7(minpsi, maxpsi, psi);
        case 3 : return SetColorWLength(minpsi, maxpsi, psi);
        case 4 : return SetColorTemp(minpsi, maxpsi, psi); 
        case 5 : return SetColorJednolity(kolor); //wybrano palet jednobarwna
    }

	return rgb_black;
}

void CWykres3D::UstawKolor()
{
    //dla wszystkich wartoci w kolumnach z zakresu jmin:jmax
    for (int j=jmin; j<=jmax; j+=every)
        //dla wszystkich wartoci w wierszach z zakresu imin:imax
        for (int i=imin; i<=imax; i+=every){
            //przypisz psi_value warto spod psi[i][j].psi_value lub kwadrat
            //tej wartoci jeli mod_psi = true
            float psi_value = mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            psi_value*=float(wsp);
            //wyznacz kolor odpowiadajacy wartoci psi_value
            psi[i][j].kolor = Kolor(min_value, max_value, psi_value);
        }
}

void CWykres3D::RysujPsiPunkty()
{
    glDeleteLists(list_id, 1);
    list_id = glGenLists(1);
    glNewList(list_id,GL_COMPILE);

    //kady vertex ma by traktowany jako punkt
    glBegin(GL_POINTS);
    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3]; //tablica przechowujaca wsprzdne x, y, z
        pkt1[1]=float(gp->GetYmin()+j*gp->GetDy()-y_sr); //wyznaczenie wsp. y
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=float(gp->GetXmin()+i*gp->GetDx()-x_sr);  //wyznaczenie wsp. x
            //wyznaczenie wsp. z, z uwzgldnieniem wartoci zmiennej mod_psi
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value;
            pkt1[2]*=float(wsp);

            //ustawienie odpowiedniego koloru rysowania
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            //wyrysowanie punktu
            glVertex3fv(pkt1);
        }
    }
    glEnd();

	glEndList();
}

void CWykres3D::RysujPsiImpulsy()
{
	glDeleteLists(list_id, 1);
    list_id = glGenLists(1);
    glNewList(list_id,GL_COMPILE);

    rgb_triplet zero = Kolor(min_value, max_value, 0.0); //kolor poziomu z=0
    //dla wszystkich danych z przedziau jmin:jmax z krokiem every
    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3];
        pkt1[1]=float(gp->GetYmin()+j*gp->GetDy()-y_sr); //wsp. y
        //dla wszystkich danych z przedziau imin:imax z krokiem every
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=float(gp->GetXmin()+i*gp->GetDx()-x_sr);  //wsp. x
            glBegin(GL_LINES);
            //pierwszy punkt linii (supka) na poziomie z=0
            glColor3ub(zero.r,zero.g,zero.b);
            pkt1[2]=0.0;
            glVertex3fv(pkt1);

            //wyznaczamy wsp. z dla psi[i][j]
            //drugi punkt linii (supka)
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            pkt1[2]*=float(wsp); //przeskalowanie
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            glVertex3fv(pkt1);
            glEnd();
        }
    }

	glEndList();
}

void CWykres3D::RysujPsiLinie()
{
	glDeleteLists(list_id, 1);
    list_id = glGenLists(1);
    glNewList(list_id,GL_COMPILE);

    for (int j=jmin; j<=jmax; j+=every) {
        float pkt1[3]; //tablica przechowujaca wsp. x, y i z
        pkt1[1]=float(gp->GetYmin()+j*gp->GetDy()-y_sr); //wsp. y
        glBegin(GL_LINE_STRIP); //poacz werteksy tworzac krzywa
        for (int i=imin; i<=imax; i+=every){
            pkt1[0]=float(gp->GetXmin()+i*gp->GetDx()-x_sr); //wsp. x
            pkt1[2]=mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value; //wsp. z
            pkt1[2]*=float(wsp); //przeskalowanie
            glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
            glVertex3fv(pkt1);
        }
        glEnd();
    }

	glEndList();
}

void CWykres3D::RysujPsiPowierzchnia()
{
	glDeleteLists(list_id, 1);
    list_id = glGenLists(1);
    glNewList(list_id,GL_COMPILE);

    float pkt1[3], pkt2[3], pkt3[3];
    for (int j=jmin; j<=jmax-1; j+=every) {
        double y=gp->GetYmin()+j*gp->GetDy()-y_sr; //wsp. y
        pkt1[1]=float(y); pkt2[1]=float(y);
        glBegin(GL_QUAD_STRIP);
        for (int i=imin; i<=imax; i+=every){
            double x=gp->GetXmin()+i*gp->GetDx()-x_sr; //wsp. x
            float normalna[3]; //tablica przechowujaca wsprzdne wektora normalnego
            //sparawdzamy czy nie wyjdziemy poza zakres sieci
            if (i+every<gp->GetNx() && j+every<gp->GetNy()) {
                //dolny lewy punkt
                pkt1[0]=float(x);
                pkt1[2]=float((mod_psi?psi[i][j].psi_value*psi[i][j].psi_value:psi[i][j].psi_value)*wsp);

                //dolny prawy punkt
                pkt2[0]=float(x+every*gp->GetDx()); //wsp. x
                pkt2[2]=float((mod_psi?psi[i+every][j].psi_value*psi[i+every][j].psi_value:psi[i+every][j].psi_value)*wsp); //wsp. z

                //gorny lewy punkt
                pkt3[0]=float(x); pkt3[1]=float(y+every*gp->GetDy());
                pkt3[2]=float((mod_psi?psi[i][j+every].psi_value*psi[i][j+every].psi_value:psi[i][j+every].psi_value)*wsp);

                //wyznaczamy wektor normalny do paszczyzny zawierajacej pkt1, pkt2 i pkt3
                JednostkowyWektorNormalny3fv(pkt1, pkt2, pkt3, normalna);

                //ustawiamy wektor normalny
                glNormal3fv(normalna);
                glColor3ub(psi[i][j].kolor.r,psi[i][j].kolor.g,psi[i][j].kolor.b);
                //"rysujemy" pierwszy punkt
                glVertex3fv(pkt1);
                glColor3ub(psi[i][j+every].kolor.r,psi[i][j+every].kolor.g,psi[i][j+every].kolor.b);
                //"rysujemy" drugi punkt
                glVertex3fv(pkt3);
            }
        }
        glEnd();
    }

	glEndList();
}

void CWykres3D::RysujAktorow()
{
	if (!error) {
		if (!glIsList(list_id))
			switch (typ) {
				case 0 : RysujPsiPunkty();       break;
				case 1 : RysujPsiLinie();        break;
				case 2 : RysujPsiPowierzchnia(); break;
				case 3 : RysujPsiImpulsy ();     break;
			}
		glCallList(list_id);
		RysujOsie();

		glEnable(GL_LIGHT1);
		ZrodlaSwiatla();
		RysujLampe(1, lposX, lposY, lposZ);		

		static bool czcionkaUtworzona = false;
		if (!czcionkaUtworzona) czcionka = StworzCzcionke(false, uchwytOkna, "Courier New", 14, false, false, 0, 255);  
		czcionkaUtworzona =true;
		UstawOpis(czcionka);
	}
}

void CWykres3D::ZrodlaSwiatla()
{
    const float kolor2_rozproszone[4]={0.25,0.25,0.25,1.0};
    const float kolor2_reflektora[4]={0.5,0.5,0.5,1.0};
	const float reflektor_kierunek[4]={0.0,0.0,-1.0,1.0};
    const float pozycja[4]={lposX, lposY, lposZ, 1.0};
    const float szerokosc_wiazki=60.0; //w stopniach

    glLightfv(GL_LIGHT1,GL_POSITION,pozycja);
    glLightfv(GL_LIGHT1,GL_DIFFUSE,kolor2_rozproszone);
    glLightfv(GL_LIGHT1,GL_SPECULAR,kolor2_reflektora);
    //glLightf(GL_LIGHT1,GL_SPOT_CUTOFF,szerokosc_wiazki);
	//glLightfv(GL_LIGHT1, GL_SPOT_DIRECTION, reflektor_kierunek);
}

void CWykres3D::RysujOsie()
{
    float  minpsi=float(min_value),
           maxpsi=float(max_value);
    float  Xmin=float(gp->GetXmin()+imin*gp->GetDx()-x_sr), //minimalna warto wsprzdnej x przesunita o x_sr
           Xmax=float(gp->GetXmin()+imax*gp->GetDx()-x_sr), //maksymalna warto wsprzdnej x przesunita o x_sr
           Ymin=float(gp->GetYmin()+jmin*gp->GetDy()-y_sr), //minimalna warto wsprzdnej y przesunita o y_sr
           Ymax=float(gp->GetYmin()+jmax*gp->GetDy()-y_sr); //maksymalna warto wsprzdnej y przesunita o y_sr

    if (minpsi>=0.0 && maxpsi>=0.0) minpsi=0.0;
    if (maxpsi<=0.0 && minpsi<=0.0) maxpsi=0.0;

    glColor3ub(0,0,0);
    //prostokat z=0
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymin,0); //wsprzdne lewego dolnego rogu
    glVertex3f(Xmin,Ymax,0); //wsprzdne lewego grnego rogu
    glVertex3f(Xmax,Ymax,0); //wsprzdne prawego grnego rogu
    glVertex3f(Xmax,Ymin,0); //wsprzdne prawego dolnego rogu
    glVertex3f(Xmin,Ymin,0); //wsprzdne lewego dolnego rogu
    glEnd();

    //prostokat x=Xmin
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymin,minpsi); //wsprzdne dolnego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymin,maxpsi); //wsprzdne dolnego rogu
    glVertex3f(Xmin,Ymax,maxpsi); //wsprzdne grnego rogu
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne grnego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymin,minpsi); //wsprzdne dolnego bardziej oddalonego rogu
    glEnd();

    //prostokat y=Ymax
    glBegin(GL_LINE_STRIP);
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne lewego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymax,maxpsi); //wsprzdne lewego rogu
    glVertex3f(Xmax,Ymax,maxpsi); //wsprzdne prawego rogu
    glVertex3f(Xmax,Ymax,minpsi); //wsprzdne prawego bardziej oddalonego rogu
    glVertex3f(Xmin,Ymax,minpsi); //wsprzdne lewego bardziej oddalonego rogu
    glEnd();
}

void CWykres3D::RysujLampe(int NrLight, float x, float y, float z)
{
	glInitNames(); // inicjalizacja stosu nazw obiektow
	glPushName(0); // umieszczanie nazwy na stosie nazw, aby nie byl on pusty
	glLoadName(NrLight);

	GLUquadricObj* kwadryka=gluNewQuadric(); //tworzenie obiektu kwadryki
	gluQuadricDrawStyle(kwadryka,GLU_FILL); //ustalenie stylu

    glPushMatrix();
    glTranslatef(x, y, z);
	glColor3f(1.0f,1.0f,0.0f);
	gluSphere(kwadryka,1,30,30); //rysowanie sfery
    glPopMatrix();

	gluDeleteQuadric(kwadryka); //usuwanie obiektu
	glLoadName(0);
}

int CWykres3D::SelekcjaObiektow(unsigned int  buforSelekcji[ROZMIAR_BUFORA_SELEKCJI], int xPos, int yPos)
{
	int ileTrafien; //ilo trafie

    //przygotowanie buffora selekcji
    glSelectBuffer(ROZMIAR_BUFORA_SELEKCJI, buforSelekcji);

    //pobranie obszaru renderingu
    int viewport[4];
    glGetIntegerv(GL_VIEWPORT, viewport);

    //szeroko i wysok obszaru renderingu
    int width = viewport[2];
    int height = viewport[3];

    // wybor macierzy rzutowania
    glMatrixMode(GL_PROJECTION);

    // odlozenie macierzy rzutowania na stos
    glPushMatrix();

    // wlaczenie trybu selekcji
    glRenderMode(GL_SELECT);

    // marierz rzutowania = macierz jednostkowa
    glLoadIdentity();

    // parametry bryly obcinania (jednostkowa kostka)
    gluPickMatrix(xPos,height - yPos, 2, 2, viewport);

    //parametyr bryly obcinania
    float wsp=wysokoscObszaruUzytkownika/(float)szerokoscObszaruUzytkownika;	
	glFrustum(-0.1, 0.1, wsp*-0.1, wsp*0.1, 0.3, 10000.0);

    // generowanie sceny 
	glMatrixMode(GL_MODELVIEW); //powrt do macierzy widoku modelu 
	RysujScene();

    // zliczanie iloci rekordow trafien i powrot do domyslnego trybu renderowania
    ileTrafien = glRenderMode(GL_RENDER);

    // wybor macierzy rzutowania
    glMatrixMode(GL_PROJECTION);

    // zdjecie macierzy rzutowania ze stosu
    glPopMatrix();

    glMatrixMode(GL_MODELVIEW);

	return ileTrafien;
}

LRESULT CWykres3D::WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam)
{
	long wynik = COknoGL::WndProc(hWnd, message, wParam, lParam);

	switch (message) {
		case WM_LBUTTONDOWN:
			unsigned int buforSelekcji[ROZMIAR_BUFORA_SELEKCJI];
			ileTrafien=SelekcjaObiektow(buforSelekcji,LOWORD(lParam),HIWORD(lParam));
			NRWybranegoObiektu = buforSelekcji[3];
			break;
		case WM_MOUSEMOVE:
			if ((wParam & MK_LBUTTON) && (NRWybranegoObiektu==1)) {
				kontrolaKameryPrzezUzytkownika = false;
				POINT lpos2D={LOWORD(lParam),HIWORD(lParam)};
				float transLpos3D[3];
				float pozLight3D[3] = {lposX, lposY, lposZ};
				double winPos[3];
				TransformujPunktScenyDoPrzestrzeniEkranu(pozLight3D, winPos);
				TransformujPikselDoPrzestrzeniSceny(lpos2D,float(winPos[2]),transLpos3D);
				lposX = transLpos3D[0];
				lposY = transLpos3D[1];
				lposZ = transLpos3D[2];
				RysujScene();
			}
			break;
		case WM_LBUTTONUP:
			ileTrafien=NRWybranegoObiektu=0;
			kontrolaKameryPrzezUzytkownika = true;
			break;
	}

	return wynik;
}

void CWykres3D::UstawOpis(int czcionka)
{
	glColor3f(0.0f, 0.0f, 0.0f);
	//o OX
	int opisOX = 4;
	double dx = (imax-imin)/(double)opisOX;
	double zn_x = (imax*gp->GetDx()-imin*gp->GetDx());
    float pkt1[3];
	pkt1[2]=0.0f;
    pkt1[1]=float(gp->GetYmin()+jmin*gp->GetDy()); //wsp. y
    //dla wszystkich danych z przedziau imin:imax z krokiem every
    for (double i=imin; i<=imax; i+=dx){
        pkt1[0]=float(gp->GetXmin()+i*gp->GetDx());  //wsp. x

		glRasterPos3f(float(pkt1[0]-x_sr-zn_x/20.0),float(pkt1[1]-y_sr-zn_x/15.0),pkt1[2]);
		Pisz(czcionka, 0, "%4.2e", pkt1[0]);

		glBegin(GL_LINES);
		glVertex3f(float(pkt1[0]-x_sr),float(pkt1[1]-y_sr),0.0f);
        glVertex3f(float(pkt1[0]-x_sr),float(pkt1[1]-y_sr-zn_x/40.0),0.0f);		
		glEnd();
	}	


	//o OY
	int opisOY = 4;
	double dy = (jmax-jmin)/(double)opisOY;
	double zn_y = (jmax*gp->GetDy()-jmin*gp->GetDy());
	pkt1[2]=0.0f;
    pkt1[0]=float(gp->GetXmin()+imin*gp->GetDx()); //wsp. x
    //dla wszystkich danych z przedziau imin:imax z krokiem every
    for (double j=jmin; j<=jmax; j+=dy){
        pkt1[1]=float(gp->GetYmin()+j*gp->GetDy());  //wsp. y

		glRasterPos3f(float(pkt1[0]-x_sr-zn_y/5.0),float(pkt1[1]-y_sr-zn_y/75.0),pkt1[2]);
		Pisz(czcionka, 0, "%4.2e", pkt1[1]);

		glBegin(GL_LINES);
		glVertex3f(float(pkt1[0]-x_sr),float(pkt1[1]-y_sr),0.0f);
        glVertex3f(float(pkt1[0]-x_sr-zn_y/75.0),float(pkt1[1]-y_sr),0.0f);		
		glEnd();
	}

	//o Z

    float  minpsi=float(min_value),
           maxpsi=float(max_value);
    if (minpsi>=0.0 && maxpsi>=0.0) minpsi=0.0;
    if (maxpsi<=0.0 && minpsi<=0.0) maxpsi=0.0;

	pkt1[2]=minpsi;
	pkt1[1]=float(gp->GetYmin()+jmin*gp->GetDy());
	glRasterPos3f(float(pkt1[0]-x_sr-zn_y/5.0),float(pkt1[1]-y_sr-zn_y/75.0),pkt1[2]);
	Pisz(czcionka, 0, "%4.2e", float(minpsi/wsp));

	pkt1[2]=maxpsi;
	glRasterPos3f(float(pkt1[0]-x_sr-zn_y/5.0),float(pkt1[1]-y_sr-zn_y/75.0),pkt1[2]);
	Pisz(czcionka, 0, "%4.2e", float(maxpsi/wsp));

	glBegin(GL_LINES);
	glVertex3f(float(pkt1[0]-x_sr),float(pkt1[1]-y_sr),minpsi);
	glVertex3f(float(pkt1[0]-x_sr-zn_y/75.0),float(pkt1[1]-y_sr),minpsi);
	glVertex3f(float(pkt1[0]-x_sr),float(pkt1[1]-y_sr),maxpsi);
	glVertex3f(float(pkt1[0]-x_sr-zn_y/75.0),float(pkt1[1]-y_sr),maxpsi);
	glEnd();
}